/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.GuiSupport;
import org.autoplot.JythonUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.dom.Application;
import org.autoplot.help.Util;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.scriptconsole.CommandLineTextPane;
import org.autoplot.scriptconsole.LogConsoleSettingsDialog;
import org.autoplot.scriptconsole.LogConsoleUtil;
import org.autoplot.scriptconsole.LoggingOutputStream;
import org.autoplot.util.TickleTimer;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.Utilities;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;
import org.python.core.PyException;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.xml.sax.SAXException;

public class LogConsole
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");
    public static final int RECORD_SIZE_LIMIT = 4000;
    List<LogRecord> records = new LinkedList<LogRecord>();
    int eventThreadId = -1;
    int level = Level.ALL.intValue();
    boolean showLoggerId = false;
    boolean showTimeStamps = false;
    boolean showLevel = false;
    boolean showThreads = false;
    NumberFormat nf = new DecimalFormat("00.000");
    private Timer timer2;
    PrintStream oldStdOut;
    PrintStream oldStdErr;
    PythonInterpreter interp = null;
    Pattern searchTextPattern = null;
    protected String searchText = "";
    public static final String PROP_SEARCHTEXT = "searchText";
    private Level logStatus = Level.ALL;
    public static final String PROP_LOGSTATUS = "logStatus";
    private boolean showOnlyHighlited = false;
    public static final String PROP_SHOWONLYHIGHLITED = "showOnlyHighlited";
    protected Map<String, Object> scriptContext = null;
    public static final String PROP_SCRIPTCONTEXT = "scriptContext";
    private volatile Handler handler;
    private static boolean alreadyLoggingStdout = false;
    Map<String, Long> entryTimes = new HashMap<String, Long>();
    private TickleTimer logStatusTimer = new TickleTimer(1000L, new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Level oldLogStatus = LogConsole.this.logStatus;
            LogConsole.this.logStatus = Level.ALL;
            LogConsole.this.firePropertyChange(LogConsole.PROP_LOGSTATUS, oldLogStatus, LogConsole.this.logStatus);
        }
    });
    private JPanel actionsPanel;
    private JLabel apLabel;
    private JButton clearButton;
    private CommandLineTextPane commandLineTextPane1;
    private JButton copyButton;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextPane logTextArea;
    private JButton saveButton;
    private List<ActionListener> consoleListeners = new ArrayList<ActionListener>();

    public LogConsole() {
        this.initComponents();
        String f = AutoplotSettings.settings().resolveProperty("autoplotData");
        File config = new File(new File(f), "config");
        Properties p = new Properties();
        if (config.exists()) {
            block17: {
                try {
                    File syntaxPropertiesFile = new File(config, "jsyntaxpane.properties");
                    logger.log(Level.FINE, "Resetting editor colors using {0}", syntaxPropertiesFile);
                    if (!syntaxPropertiesFile.exists()) break block17;
                    try (FileInputStream in = new FileInputStream(syntaxPropertiesFile);){
                        p.load(in);
                    }
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            this.logTextArea.setBackground(Color.decode(p.getProperty("Background", "0xFFFFFF")));
            String foreground = p.getProperty("Style.DEFAULT", "0x000000");
            int i = foreground.indexOf(",");
            if (i > -1) {
                foreground = foreground.substring(0, i);
            }
            this.logTextArea.setForeground(Color.decode(foreground));
        }
        this.commandLineTextPane1.addActionListener(e -> {
            LoggerManager.logGuiEvent((ActionEvent)e);
            String s = this.commandLineTextPane1.getText();
            RequestProcessor.invokeLater(() -> {
                try {
                    String s1 = LogConsole.maybeRemovePrompts(s);
                    s1 = JythonRefactory.fixImports((String)s1);
                    System.out.println("AP> " + s1);
                    this.maybeInitializeInterpreter();
                    try {
                        PyObject po = this.interp.eval(s1);
                        if (!(po instanceof PyNone)) {
                            try {
                                this.interp.exec("print '" + po.__str__() + "'");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    catch (PyException ex) {
                        this.interp.exec(s1);
                    }
                    this.commandLineTextPane1.setText("");
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    this.commandLineTextPane1.setText("");
                }
                catch (PyException ex) {
                    System.err.println(ex.toString());
                    this.commandLineTextPane1.setText("");
                }
            });
        });
        this.commandLineTextPane1.putClientProperty("JYTHON_INTERPRETER_PROVIDER", new JythonInterpreterProvider(){

            public PythonInterpreter createInterpreter() throws IOException {
                LogConsole.this.maybeInitializeInterpreter();
                return LogConsole.this.interp;
            }
        });
        this.logTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2 && e.isShiftDown()) {
                    int caret = LogConsole.this.logTextArea.viewToModel(new Point(e.getX(), e.getY()));
                    try {
                        String word = Utilities.getWordAt((JTextPane)LogConsole.this.logTextArea, (int)caret);
                        if (word.startsWith("http:") || word.startsWith("https:")) {
                            Util.openBrowser((String)word);
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.timer2 = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogConsole.this.isShowing()) {
                    LogConsole.this.update();
                } else {
                    LogConsole.this.timer2.restart();
                }
            }
        });
        this.timer2.setRepeats(false);
        final JTextPane ftxt = this.logTextArea;
        this.logTextArea.getActionMap().put("biggerFont", new AbstractAction("Text Size Bigger"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font f = ftxt.getFont();
                float size = f.getSize2D();
                float step = size < 14.0f ? 1.0f : 2.0f;
                ftxt.setFont(f.deriveFont(Math.min(40.0f, size + step)));
            }
        });
        this.logTextArea.getActionMap().put("smallerFont", new AbstractAction("Text Size Smaller"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font f = ftxt.getFont();
                float size = f.getSize2D();
                float step = size < 14.0f ? 1.0f : 2.0f;
                ftxt.setFont(f.deriveFont(Math.max(4.0f, size - step)));
            }
        });
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.logTextArea.getInputMap().put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "biggerFont");
        this.logTextArea.getInputMap().put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "smallerFont");
    }

    public static String maybeRemovePrompts(String s) {
        CharSequence[] ss = s.split("\n", -2);
        for (int i = 0; i < ss.length; ++i) {
            String s1 = ss[i];
            if (s1.startsWith("AP> ")) {
                ss[i] = s1.substring(4);
                continue;
            }
            if (s1.startsWith(">>> ")) {
                ss[i] = s1.substring(4);
                continue;
            }
            if (!s1.startsWith("... ")) continue;
            ss[i] = s1.substring(4);
        }
        return String.join((CharSequence)"\n", ss);
    }

    private void maybeInitializeInterpreter() throws IOException {
        if (this.interp == null) {
            String s = this.commandLineTextPane1.getText();
            int ipos = this.commandLineTextPane1.getCaretPosition();
            this.commandLineTextPane1.setText("initializing interpretter...");
            this.interp = JythonUtil.createInterpreter(true, false, (Application)this.scriptContext.get("dom"), null);
            if (this.scriptContext != null) {
                for (Map.Entry<String, Object> e : this.scriptContext.entrySet()) {
                    this.interp.set(e.getKey(), e.getValue());
                }
            }
            this.commandLineTextPane1.setText(s);
            this.commandLineTextPane1.setCaretPosition(ipos);
        }
    }

    public String getSearchText() {
        return this.searchText;
    }

    public Level getLogStatus() {
        return this.logStatus;
    }

    private boolean isRegex(String s) {
        try {
            Pattern.compile(s);
            return true;
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    public void setSearchText(String searchText) {
        String oldSearchText;
        block5: {
            oldSearchText = this.searchText;
            this.searchText = searchText;
            if (searchText != null && searchText.length() > 0) {
                try {
                    if (this.isRegex(searchText)) {
                        this.searchTextPattern = Pattern.compile(searchText);
                        break block5;
                    }
                    this.searchTextPattern = Pattern.compile(Pattern.quote(searchText));
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            } else {
                this.searchTextPattern = null;
            }
        }
        this.logTextArea.setToolTipText(null);
        this.apLabel.setToolTipText(null);
        this.update();
        this.firePropertyChange(PROP_SEARCHTEXT, oldSearchText, searchText);
    }

    public boolean isShowOnlyHighlited() {
        return this.showOnlyHighlited;
    }

    public void setShowOnlyHighlited(boolean showOnlyHighlited) {
        boolean oldShowOnlyHighlited = this.showOnlyHighlited;
        this.showOnlyHighlited = showOnlyHighlited;
        this.update();
        this.firePropertyChange(PROP_SHOWONLYHIGHLITED, oldShowOnlyHighlited, showOnlyHighlited);
    }

    public void setShowLoggerId(boolean selected) {
        this.showLoggerId = selected;
    }

    public void setShowTimeStamps(boolean selected) {
        this.showTimeStamps = selected;
    }

    public void setShowLevel(boolean selected) {
        this.showLevel = selected;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setShowThreads(boolean selected) {
        this.showThreads = selected;
    }

    protected JTextPane getLogTextArea() {
        return this.logTextArea;
    }

    public Map<String, Object> getScriptContext() {
        return this.scriptContext;
    }

    public void setScriptContext(Map<String, Object> scriptContext) {
        Map<String, Object> oldScriptContext = this.scriptContext;
        this.scriptContext = scriptContext;
        this.firePropertyChange(PROP_SCRIPTCONTEXT, oldScriptContext, scriptContext);
    }

    private LogConsoleSettingsDialog getSettingsDialog() {
        LogConsoleSettingsDialog settingsDialog = new LogConsoleSettingsDialog(GuiSupport.getFrameForComponent(this), true, this);
        return settingsDialog;
    }

    private Handler newHandler() {
        return new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publish(LogRecord rec) {
                Object[] parms = rec.getParameters();
                String rm1 = rec.getMessage();
                String recMsg = rm1 != null ? (rm1.startsWith("ENTRY") ? (rm1.startsWith("ENTRY {0}") ? "ENTRY " + rec.getSourceClassName() + "." + rec.getSourceMethodName() + rm1.substring(9) : "ENTRY " + rec.getSourceClassName() + "." + rec.getSourceMethodName()) : (rm1.startsWith("RETURN") ? (rm1.startsWith("RETURN {0}") ? "RETURN " + rec.getSourceClassName() + "." + rec.getSourceMethodName() + rm1.substring(10) : "RETURN " + rec.getSourceClassName() + "." + rec.getSourceMethodName()) : rec.getMessage())) : null;
                if (parms != null && parms.length > 0) {
                    try {
                        recMsg = MessageFormat.format(recMsg, parms);
                    }
                    catch (NullPointerException ex) {
                        recMsg = String.valueOf(rec.getMessage());
                    }
                }
                if ((recMsg == null || recMsg.length() < 4) && rec.getThrown() != null) {
                    recMsg = rec.getThrown().toString();
                    rec.getThrown().printStackTrace();
                } else {
                    boolean ex = false;
                }
                if (LogConsole.this.consoleListeners.size() > 0 && recMsg != null) {
                    ActionEvent actionEvent = new ActionEvent(this, recMsg.hashCode(), recMsg);
                    LogConsole.this.consoleListeners.forEach(al -> al.actionPerformed(actionEvent));
                }
                if (LogConsole.this.searchTextPattern != null && LogConsole.this.searchTextPattern.matcher(recMsg).find()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (PrintWriter pw = new PrintWriter(baos);){
                        new Exception().printStackTrace(pw);
                    }
                    try {
                        String s = baos.toString("US-ASCII");
                        String[] ss = s.split("\n");
                        StringBuilder sb = new StringBuilder("<html><b>Stack trace at last highlite match:</b>");
                        for (String s1 : ss) {
                            sb.append(s1).append("<br>");
                        }
                        sb.append("</html>");
                        String msg = sb.toString();
                        LogConsole.this.apLabel.setToolTipText(msg);
                    }
                    catch (UnsupportedEncodingException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                    LogConsoleUtil.checkBreakpoint();
                }
                LogRecord copy = new LogRecord(rec.getLevel(), recMsg);
                copy.setLoggerName(rec.getLoggerName());
                copy.setMillis(rec.getMillis());
                LogConsole ex = LogConsole.this;
                synchronized (ex) {
                    LogConsole.this.records.add(copy);
                    while (LogConsole.this.records.size() > 4000) {
                        LogConsole.this.records.remove(0);
                    }
                    LogConsole.this.timer2.restart();
                    if (LogConsole.this.eventThreadId == -1 && EventQueue.isDispatchThread()) {
                        LogConsole.this.eventThreadId = rec.getThreadID();
                    }
                }
                if (rec.getLevel().intValue() >= Level.WARNING.intValue() && LogConsole.this.oldStdErr != null) {
                    String msg = rec.getMessage();
                    String recMsg1 = parms == null || parms.length == 0 ? msg : MessageFormat.format(msg, parms);
                    LogConsole.this.oldStdErr.println(recMsg1);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }

            public String toString() {
                return "LogConsole.Handler";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler getHandler() {
        Handler h = this.handler;
        if (h == null) {
            LogConsole logConsole = this;
            synchronized (logConsole) {
                h = this.handler;
                if (h == null) {
                    this.handler = h = this.newHandler();
                    h.setLevel(Level.ALL);
                }
            }
        }
        return h;
    }

    public void logConsoleMessages() {
        if (alreadyLoggingStdout) {
            System.err.println("already logging stdout and stderr");
            return;
        }
        alreadyLoggingStdout = true;
        Logger llogger = LoggerManager.getLogger((String)"console.stdout");
        LoggingOutputStream los = new LoggingOutputStream(llogger, Level.INFO);
        this.oldStdOut = System.out;
        System.setOut(new PrintStream(los, true));
        llogger = LoggerManager.getLogger((String)"console.stderr");
        los = new LoggingOutputStream(llogger, Level.WARNING);
        this.oldStdErr = System.err;
        System.setErr(new PrintStream(los, true));
    }

    public void undoLogConsoleMessages() {
        if (this.oldStdOut != null) {
            System.setOut(this.oldStdOut);
        }
        if (this.oldStdErr != null) {
            System.setErr(this.oldStdErr);
        }
    }

    public void turnOffConsoleHandlers() {
        System.err.println("turning off default log, look for messages in console tab.");
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            h.setLevel(Level.OFF);
        }
    }

    private String getRecMsg(long baseTime, LogRecord rec) {
        Long t1;
        long t = baseTime;
        boolean timeStamps = this.showTimeStamps;
        boolean logLevels = this.showLevel;
        boolean threads = this.showThreads;
        String msg = rec.getMessage();
        Object[] parms = rec.getParameters();
        String recMsg = parms == null || parms.length == 0 ? msg : MessageFormat.format(msg, parms);
        if (recMsg == null) {
            recMsg = "null";
        }
        if (recMsg.startsWith("ENTRY ")) {
            int i = recMsg.indexOf(32, 6);
            if (i == -1) {
                i = recMsg.length();
            }
            this.entryTimes.put(recMsg.substring(6, i), rec.getMillis());
        } else if (recMsg.startsWith("RETURN ") && (t1 = this.entryTimes.remove(recMsg.substring(7))) != null) {
            recMsg = recMsg + " (" + (rec.getMillis() - t1) + "ms)";
        }
        String prefix = "";
        if (rec.getMessage() == null) {
            if (rec.getThrown() != null) {
                recMsg = recMsg + rec.getThrown().toString();
            }
            prefix = prefix + ";";
        }
        if (this.showLoggerId) {
            prefix = prefix + rec.getLoggerName() + " ";
        }
        if (timeStamps) {
            prefix = prefix + this.nf.format((double)(t - rec.getMillis()) / 1000.0) + " ";
        }
        if (logLevels) {
            prefix = prefix + rec.getLevel() + " ";
        }
        if (threads) {
            prefix = rec.getThreadID() == this.eventThreadId ? prefix + "(GUI) " : prefix + rec.getThreadID();
        }
        if (!prefix.equals("")) {
            recMsg = prefix.trim() + ": " + recMsg;
        }
        return recMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        ArrayList<LogRecord> lrecords;
        LogConsole logConsole = this;
        synchronized (logConsole) {
            lrecords = new ArrayList<LogRecord>(this.records);
        }
        try {
            int n = lrecords.size();
            String st = this.searchText;
            if (st != null && st.length() == 0) {
                st = null;
            }
            Pattern p = this.searchTextPattern;
            StyledDocument doc = this.logTextArea.getStyledDocument();
            doc.remove(0, doc.getLength());
            SimpleAttributeSet highlistAttr = new SimpleAttributeSet();
            StyleConstants.setBackground(highlistAttr, Color.ORANGE);
            long t = n == 0 ? 0L : ((LogRecord)lrecords.get(n - 1)).getMillis();
            this.entryTimes = new HashMap<String, Long>();
            for (LogRecord rec : lrecords) {
                if (rec.getLevel().intValue() < this.level) continue;
                if (this.getLogStatus().intValue() < rec.getLevel().intValue()) {
                    Level oldLogStatus = this.logStatus;
                    this.logStatus = rec.getLevel();
                    this.logStatusTimer.tickle();
                    this.firePropertyChange(PROP_LOGSTATUS, oldLogStatus, this.logStatus);
                }
                String recMsg = this.getRecMsg(t, rec);
                SimpleAttributeSet attr = null;
                if (st != null && p != null && p.matcher(recMsg).find()) {
                    attr = highlistAttr;
                }
                try {
                    recMsg = recMsg + "\n";
                    if (this.showOnlyHighlited && st != null) {
                        if (attr == null) continue;
                        doc.insertString(doc.getLength(), recMsg, null);
                        continue;
                    }
                    doc.insertString(doc.getLength(), recMsg, attr);
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void initComponents() {
        this.actionsPanel = new JPanel();
        this.clearButton = new JButton();
        this.saveButton = new JButton();
        this.copyButton = new JButton();
        this.apLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.commandLineTextPane1 = new CommandLineTextPane();
        this.jScrollPane1 = new JScrollPane();
        this.logTextArea = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
            }
        };
        this.jButton1 = new JButton();
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("clear all messages.  ");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.clearButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save As...");
        this.saveButton.setToolTipText("saves the records to file for use by software support team.  (Ctrl+ will load in previously externally saved records.)");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.saveButtonActionPerformed(evt);
            }
        });
        this.copyButton.setText("Copy");
        this.copyButton.setToolTipText("copy xml of log records into system clipboard, for pasting into email.\n");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.copyButtonActionPerformed(evt);
            }
        });
        GroupLayout actionsPanelLayout = new GroupLayout((Container)this.actionsPanel);
        this.actionsPanel.setLayout((LayoutManager)actionsPanelLayout);
        actionsPanelLayout.setHorizontalGroup((GroupLayout.Group)actionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionsPanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.clearButton).addPreferredGap(0).add((Component)this.saveButton).addPreferredGap(0).add((Component)this.copyButton).addContainerGap(18, Short.MAX_VALUE)));
        actionsPanelLayout.setVerticalGroup((GroupLayout.Group)actionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionsPanelLayout.createParallelGroup(3).add((Component)this.clearButton).add((Component)this.saveButton).add((Component)this.copyButton)));
        this.apLabel.setText("AP>");
        this.commandLineTextPane1.setToolTipText("enter jython commands here to control the application, for example \"plot(dataset([1,2,3]))\"");
        this.commandLineTextPane1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LogConsole.this.commandLineTextPane1FocusGained(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.commandLineTextPane1);
        this.logTextArea.setEditable(false);
        this.jScrollPane1.setViewportView(this.logTextArea);
        this.jButton1.setText("Console Settings...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 560, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.actionsPanel, -2, -1, -2).addPreferredGap(0, 159, Short.MAX_VALUE).add((Component)this.jButton1)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.apLabel).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 484, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 319, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(8, 8, 8).add((Component)this.apLabel)).add((Component)this.jScrollPane2, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.actionsPanel, -2, -1, -2).add((Component)this.jButton1))));
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.records.clear();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent evt) {
        block46: {
            LoggerManager.logGuiEvent((ActionEvent)evt);
            if ((evt.getModifiers() & 2) == 2) {
                JFileChooser chooser = new JFileChooser();
                chooser.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.toString().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return "xml files";
                    }
                });
                if (0 == chooser.showOpenDialog(this)) {
                    FileInputStream fo = null;
                    try {
                        fo = new FileInputStream(chooser.getSelectedFile());
                        this.records = LogConsoleUtil.deserializeLogRecords(fo);
                    }
                    catch (IOException | ParserConfigurationException | SAXException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    finally {
                        try {
                            if (fo != null) {
                                fo.close();
                            }
                        }
                        catch (IOException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                chooser.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.toString().endsWith(".xml") || f.toString().endsWith(".txt");
                    }

                    @Override
                    public String getDescription() {
                        return "xml files or txt files";
                    }
                });
                if (0 == chooser.showSaveDialog(this)) {
                    File f = chooser.getSelectedFile();
                    ArrayList<LogRecord> copy = new ArrayList<LogRecord>(this.records);
                    try (FileOutputStream fo = new FileOutputStream(chooser.getSelectedFile());){
                        if (f.toString().endsWith(".xml")) {
                            LogConsoleUtil.serializeLogRecords(copy, fo);
                            break block46;
                        }
                        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter(fo));){
                            if (copy.size() > 0) {
                                long t = ((LogRecord)copy.get(copy.size() - 1)).getMillis();
                                for (LogRecord rec : copy) {
                                    if (rec.getLevel().intValue() < this.level) continue;
                                    String recMsg = this.getRecMsg(t, rec);
                                    recMsg = recMsg + "\n";
                                    write.write(recMsg);
                                }
                            }
                        }
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        }
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            LogConsoleUtil.serializeLogRecords(this.records, out);
            out.close();
            StringSelection stringSelection = new StringSelection(out.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void commandLineTextPane1FocusGained(FocusEvent evt) {
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup((JTextComponent)this.commandLineTextPane1);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.getSettingsDialog().setVisible(true);
    }

    public void addConsoleListener(ActionListener listener) {
        this.consoleListeners.add(listener);
    }
}

